package jadean.dean.java.resources;

import jadean.dean.Resource;
import jadean.dean.java.JavaPackage;
import jadean.dean.java.JavaProject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;


public class JavaResourceReferencedPackage extends JavaResourceProjectResource {

	public JavaResourceReferencedPackage(String name, JavaResourceContext context, JavaProject p) {
		super(name, context, p);
	}

	@Override
	public Collection<Resource> getReferrencedResources() {
		JavaPackage pa = this.getPackageForResource();
		try {
			List<String> a = pa.getResourcesInPackage(this.getName());
			ArrayList<Resource> ret = new ArrayList<Resource>();
			JavaResourceFactory rf = new JavaResourceFactory(this.getProject());
			JavaResourceContext cnc = new JavaResourceContext();
			for (String s: a) {
				ret.add(rf.classNameToResource(s, cnc));
			}
			return ret;
		}
		catch (IOException e) {
			return new ArrayList<Resource>();
		}
	}

	@Override
	public JavaPackage getPackageForResource() {
		for (JavaPackage _p: this.getProject().getClassesInReferencedLibraries().keySet()) {
			for (String s: this.getProject().getClassesInReferencedLibraries().get(_p)) {
				if (s.startsWith(this.getName().replace(".*", ""))) {
					return _p;
				}
			}
		}
		return null;
	}

	@Override
	public void delete() {
		
	}

}
